//
//  Generated by OWNBRANDER on Fri, 02 Aug 2024 13:03:02 +0000
//

#pragma once

#include "libsync/theme.h"
#include "common/version.h"

#include <QDebug>
#include <QIcon>
#include <QPixmap>
#include <QString>

namespace OCC {

class KiteworksTheme : public Theme {
public:
  KiteworksTheme() {};
  QString configFileName() const override { return QLatin1String("kiteworks.cfg"); }

  QString defaultServerFolder() const override { return QStringLiteral("/"); }
  QString quotaBaseFolder() const override { return QStringLiteral("/"); }
  QString conflictHelpUrl() const override { return QString(); }

  QString wizardUrlPostfix() const override { return QStringLiteral(""); }
  QString wizardUrlPlaceholder() const override { return QStringLiteral("https://kiteworks.com"); }

  // in theory we want to use system colors for kiteworks wizard, so that it matches the main window. The base impl - for reasons I don't understand -
  // returns the app's palette's text color for the wizardHeaderTitleColor, but returns invalid qcolor for the background color.
  // I think it's better if both colors are invalid but let's see.
  // QColor wizardHeaderBackgroundColor() const override { return QColor("#0f152a"); }
  // QColor wizardHeaderTitleColor() const override { return QColor("#ffffff"); }

  QmlButtonColor primaryButtonColor() const override
  {
      return {{"#425cc7"}, Qt::white, QColor(Qt::white).darker(150)};
  }
  QmlButtonColor secondaryButtonColor() const override { return {{"#d4d3d0"}, Qt::black, QColor(Qt::black).lighter()}; }


  QColor avatarColor() const override { return {"#F4B223"}; }
  QColor avatarColorChecked() const override { return Resources::isUsingDarkTheme() ? QColor{"#33394C"} : QColor{"#F0F0EF"}; }

  bool forceSystemNetworkProxy() const override { return false; }

  QIcon wizardHeaderLogo() const override
  {
      if (!wizardHeaderBackgroundColor().isValid() && Resources::isUsingDarkTheme())
          return Resources::themeUniversalIcon(QStringLiteral("wizard_logo_dark"));
      else
          return Resources::themeUniversalIcon(QStringLiteral("wizard_logo"));
  }

  QIcon wizardFooterLogo() const override
  {
      return Resources::themeUniversalIcon(QStringLiteral("wizard_footer_logo"));
  }

  bool singleSyncFolder() const override { return false; }
  bool multiAccount() const override { return true; }
  bool userGroupSharing() const override { return true; }
  bool linkSharing() const override { return true; }

  UserIDType userIDType() const override { return UserIDUserName; }

  QString oauthClientId() const override { return QStringLiteral("d59d3bf0-f5d3-5534-afe4-09c7980c0163"); }

  QString oauthClientSecret() const override { return QStringLiteral("7p#mosnNmvqe"); }

  QVector<quint16> oauthPorts() const override { return {11000, 11001, 11002, 11003, 11004, 11006, 11007, 11008, 11009, 11010}; }

  QString openIdConnectScopes() const override { return QString(); }

  QString openIdConnectPrompt() const override { return QStringLiteral("select_account consent"); }

  bool oidcEnableDynamicRegistration() const override { return true; }

  QString overrideServerPath() const override { return QStringLiteral("/kwdav/"); }
  QString helpUrl() const override { return QString(); }
  QString about() const override
  {
      QString devString = tr("<p>Version %1. For more information visit <a "
                             "href=\"https://%2\">https://%2</a></p>")
                              .arg(Version::displayString().toHtmlEscaped(), QStringLiteral(APPLICATION_DOMAIN).toHtmlEscaped());
      devString += tr("<p>Copyright ownCloud GmbH (A Kiteworks Company)</p>");
      devString += tr("<p>Distributed by %1 and licensed under the GNU General "
                      "Public License (GPL) Version 2.0.<br/>")
                       .arg(Utility::escape(vendor()));

      return devString;
  }

  bool aboutShowCopyright() const override { return true; }

  bool showVirtualFilesOption() const override { return true; }

  bool forceVirtualFilesOption() const override { return true; }

  bool connectionValidatorClearCookies() const override { return false; }

  bool enableSocketApiIconSupport() const override { return true; }

  bool allowDuplicatedFolderSyncPair() const override { return true; }

  bool wizardEnableWebfinger() const override { return false; }

  bool spacesAreCalledFolders() const override { return true; }
};

} // namespace OCC
