# Contributing to the Microsoft Graph PHP SDK
Thanks for considering making a contribution! Read over our guidelines and we will do our best to see your PRs merged successfully.

**NOTE**: A signed a contribution license agreement is required for all contributions and is checked automatically on new pull requests. You will be asked to read and sign the agreement https://cla.microsoft.com/ after submitting a request to this repository.

There are a few different recommended paths to get contributions into the released version of this library.

## File issues
The best way to get started with a contribution is to start a dialog with us. Sometimes features will be under development or out of scope for this library and it's best to check before starting work on contribution, especially for large work items.

## Pull requests
If you are making documentation changes, feel free to submit a pull request against the **master** branch. All other pull requests should be submitted against the **dev** branch or a specific feature branch. The master branch is intended to represent the code released in the most-recent composer package.

When a new package is about to be released, changes in dev will be merged into master. The package will be generated from master.

Some things to note about this project:

### How the library is built
The PHP SDK has a handwritten set of core files and a folder of autogenerated models. These models are generated using the [MSGraph SDK Code Generator](https://github.com/microsoftgraph/MSGraph-SDK-Code-Generator). **Changes made to the ```Models``` folder will be overwritten** the next time the generator is run. 

If you would like to make changes to the models, you can either file an issue or make a PR in the [MSGraph SDK Code Generator](https://github.com/microsoftgraph/MSGraph-SDK-Code-Generator) to the [templates](https://github.com/microsoftgraph/MSGraph-SDK-Code-Generator/tree/master/Templates/PHP/Model). Although there is a lot of logic in the generator, the code used for PHP is fairly minimal.

### How the generator works
You can view the [README](https://github.com/microsoftgraph/MSGraph-SDK-Code-Generator/blob/master/README.md) for a full run-through of its capabilities.

For the purposes of the PHP library, the generator runs through an OData-compliant metadata file published by Microsoft Graph (https://graph.microsoft.com/v1.0/$metadata) and builds up a list of models. These models are converted into PHP code using T4 templates, which use C# to programmatically define what PHP code is written to the file.

### When new features are added to the library
Generation happens as part of a manual process that occurs once a significant change or set of changes has been added to the Graph. This may include:
 - A new workload comes to v1.0 of Graph (Microsoft Teams, Batching, etc.)
 - There is significant addition of functionality (Delta Queries, etc.)
 
However, this is evaluated on a case-by-case basis. If the library is missing v1.0 Graph functionality that you wish to utilize, please [file an issue](https://github.com/microsoftgraph/msgraph-sdk-php/issues).

We do our best to prevent breaking changes from being introduced into the library during this process. If you find a breaking change, please file an issue and we will work to get this resolved ASAP.


