@cli
Feature: Apps path
  As an admin
  I want to be able to get an absolute path to the app directory
  So that I can manage the apps in my ownCloud server

  Background:
    Given app "multidirtest" with version "1.0.2" has been put in dir "apps"


  Scenario: Two apps_path exist by default. The first one is more recent
    Given app "multidirtest" with version "1.0.1" has been put in dir "apps-external"
    When the administrator gets the path for app "multidirtest" using the occ command
    Then the command should have been successful
    And the path to "multidirtest" should be "apps"


  Scenario: Two apps_path exist by default. The second one is more recent
    Given app "multidirtest" with version "1.0.10" has been put in dir "apps-external"
    When the administrator gets the path for app "multidirtest" using the occ command
    Then the command should have been successful
    And the path to "multidirtest" should be "apps-external"


  Scenario: Three app instances, including apps-external, exist. The first one is more recent
    Given these apps' path has been configured additionally with following attributes:
      | dir         | is_writable |
      | apps-custom | true        |
    And app "multidirtest" with version "1.0.1" has been put in dir "apps-external"
    And app "multidirtest" with version "1.0.0" has been put in dir "apps-custom"
    When the administrator gets the path for app "multidirtest" using the occ command
    Then the command should have been successful
    And the path to "multidirtest" should be "apps"


  Scenario: Three app instances, including apps-external, exist. The second one is more recent
    Given these apps' path has been configured additionally with following attributes:
      | dir         | is_writable |
      | apps-custom | true        |
    And app "multidirtest" with version "1.0.10" has been put in dir "apps-external"
    And app "multidirtest" with version "1.0.0" has been put in dir "apps-custom"
    When the administrator gets the path for app "multidirtest" using the occ command
    Then the command should have been successful
    And the path to "multidirtest" should be "apps-external"


  Scenario: Three app instances, including apps-external, exist. The third one is more recent
    Given these apps' path has been configured additionally with following attributes:
      | dir         | is_writable |
      | apps-custom | true        |
    And app "multidirtest" with version "1.0.1" has been put in dir "apps-external"
    And app "multidirtest" with version "1.0.10" has been put in dir "apps-custom"
    When the administrator gets the path for app "multidirtest" using the occ command
    Then the command should have been successful
    And the path to "multidirtest" should be "apps-custom"
