<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Iam;

class PermissionDelta extends \Google\Collection
{
  protected $collection_key = 'removedPermissions';
  public $addedPermissions;
  public $removedPermissions;

  public function setAddedPermissions($addedPermissions)
  {
    $this->addedPermissions = $addedPermissions;
  }
  public function getAddedPermissions()
  {
    return $this->addedPermissions;
  }
  public function setRemovedPermissions($removedPermissions)
  {
    $this->removedPermissions = $removedPermissions;
  }
  public function getRemovedPermissions()
  {
    return $this->removedPermissions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PermissionDelta::class, 'Google_Service_Iam_PermissionDelta');
