@api @skipOnOcis-OC-Storage @issue-product-280
Feature: propagation of etags when restoring a version of a file

  Background:
    Given using OCS API version "2"
    And using new DAV path
    And user "Alice" has been created with default attributes and without skeleton files

  @skipOnStorage:ceph @skipOnStorage:scality @issue-files_primary_s3-387
  Scenario: Restoring a file changes the etags of all parents
    Given user "Alice" has created folder "/upload"
    And user "Alice" has created folder "/upload/sub"
    And user "Alice" has uploaded file with content "uploaded content" to "/upload/sub/file.txt"
    And user "Alice" has uploaded file with content "changed content" to "/upload/sub/file.txt"
    And user "Alice" has stored etag of element "/"
    And user "Alice" has stored etag of element "/upload"
    And user "Alice" has stored etag of element "/upload/sub"
    When user "Alice" restores version index "1" of file "/upload/sub/file.txt" using the WebDAV API
    Then these etags should have changed:
      | user  | path        |
      | Alice | /           |
      | Alice | /upload     |
      | Alice | /upload/sub |
